Ext.data.JsonP.sol_common_fx_ix_FxUtils({"tagname":"class","name":"sol.common_fx.ix.FxUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common_fx.ix.FxUtils.js","href":"lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.0"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"configuration","tagname":"property","owner":"sol.common_fx.ix.FxUtils","id":"property-configuration","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common_fx.ix.FxUtils","id":"property-logger","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addExchangeRateHistory","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-addExchangeRateHistory","meta":{}},{"name":"calcIsoDates","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-calcIsoDates","meta":{"private":true}},{"name":"collectCurrentCurrencyCodes","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-collectCurrentCurrencyCodes","meta":{}},{"name":"convertAmount","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-convertAmount","meta":{}},{"name":"convertLocalCurrency","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-convertLocalCurrency","meta":{}},{"name":"fillHistoricData","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-fillHistoricData","meta":{"private":true}},{"name":"getExchangeRateByCodeAndDate","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-getExchangeRateByCodeAndDate","meta":{}},{"name":"getExchangeRateForCurrency","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-getExchangeRateForCurrency","meta":{"private":true}},{"name":"getExchangeRates","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-getExchangeRates","meta":{"private":true}},{"name":"getHistoricalExchangeRate","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-getHistoricalExchangeRate","meta":{"private":true}},{"name":"getOldestEntryForCurrency","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-getOldestEntryForCurrency","meta":{}},{"name":"historicDataFilled","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-historicDataFilled","meta":{"private":true}},{"name":"historyTableHasEntries","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-historyTableHasEntries","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"latestHistoryDateIsCurrent","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-latestHistoryDateIsCurrent","meta":{"private":true}},{"name":"loadExchangeRates","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-loadExchangeRates","meta":{}},{"name":"parseDate","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-parseDate","meta":{"private":true}},{"name":"queryHistoricalExchangeRateByPeriod","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-queryHistoricalExchangeRateByPeriod","meta":{}},{"name":"recordExchangeRateHistory","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-recordExchangeRateHistory","meta":{"private":true}},{"name":"sortExchangeRateEntries","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-sortExchangeRateEntries","meta":{"private":true}},{"name":"updateExchangeRateHistory","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-updateExchangeRateHistory","meta":{}},{"name":"updateExchangeRates","tagname":"method","owner":"sol.common_fx.ix.FxUtils","id":"method-updateExchangeRates","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common_fx.ix.FxUtils","short_doc":"Contains functions for loading exchange rates and converting amounts. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common_fx.ix.FxUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils' target='_blank'>lib_sol.common_fx.ix.FxUtils.js</a></div></pre><div class='doc-contents'><p>Contains functions for loading exchange rates and converting amounts.</p>\n\n<p>Exchange rates refer to EUR as base currency.</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-configuration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-property-configuration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-property-configuration' class='name expandable'>configuration</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{baseCurrency: &quot;EUR&quot;, serviceUrl: &quot;https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml&quot;, serviceUrlHistory: &quot;https://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist.xml&quot;, regex: /&lt;Cube currency=&#39;(.*?)&#39; rate=&#39;(.*?)&#39;\\/&gt;/g, timeRegex: /&lt;Cube time=&#39;(.*?)&#39;&gt;/, timeFormat: &quot;yyyy-MM-dd&quot;, isoDateTimeFormat: &quot;YYYYMMDDHHmmss&quot;, updateStatement: &quot;UPDATE sol_common_fx SET currency_exchange_rate=?,time=? WHERE currency_code=?&quot;, selectStatement: &quot;SELECT currency_code, currency_exchange_rate FROM sol_common_fx WHERE currency_code=?&quot;, selectHistoryCountStatement: &quot;SELECT COUNT(*) FROM sol_common_fx_history&quot;, selectCurrencyCodesStatement: &quot;SELECT currency_code FROM sol_common_fx&quot;, truncateHistoryTable: &quot;TRUNCATE TABLE sol_common_fx_history&quot;, selectHistoryStatement: &quot;SELECT currency_code, currency_exchange_rate, time FROM sol_common_fx_history WHERE currency_code=? AND time=?&quot;, updateHistoryStatement: &quot;UPDATE sol_common_fx_history SET currency_exchange_rate=? WHERE currency_code=? AND time=?&quot;, insertHistoryStatement: &quot;INSERT INTO sol_common_fx_history (currency_code, currency_exchange_rate, time, base_currency_code) VALUES ( ?, ?, ?, ?)&quot;, selectByDateAndCodeStatement: &quot;SELECT currency_exchange_rate, time FROM sol_common_fx_history WHERE currency_code=? AND time &gt;=? AND time &lt;=? ORDER BY time&quot;, selectOldestEntryByCodeStatement: &quot;SELECT currency_exchange_rate, time FROM sol_common_fx_history WHERE currency_code=? AND time=(SELECT MIN(time) FROM sol_common_fx_history WHERE currency_code=?)&quot;, selectYoungestBaseCurrencyEntryStatement: &quot;SELECT time FROM sol_common_fx_history WHERE currency_code=? AND time=(SELECT MAX(time) FROM sol_common_fx_history WHERE currency_code =?)&quot;}</code></p></div></div></div><div id='property-logger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-property-logger' class='name expandable'>logger</a> : Function<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addExchangeRateHistory' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-addExchangeRateHistory' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-addExchangeRateHistory' class='name expandable'>addExchangeRateHistory</a>( <span class='pre'>results</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Inserts new entries into the history table ...</div><div class='long'><p>Inserts new entries into the history table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>results</span> : Array<div class='sub-desc'><p>results</p>\n</div></li></ul></div></div></div><div id='method-calcIsoDates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-calcIsoDates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-calcIsoDates' class='name expandable'>calcIsoDates</a>( <span class='pre'>isoDate</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calculates ISO Date Strings ...</div><div class='long'><p>Calculates ISO Date Strings</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDate</span> : String<div class='sub-desc'><p>isoDate, ELO iso date string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>dates</p>\n</div></li></ul></div></div></div><div id='method-collectCurrentCurrencyCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-collectCurrentCurrencyCodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-collectCurrentCurrencyCodes' class='name expandable'>collectCurrentCurrencyCodes</a>( <span class='pre'></span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>gets currency codes form sol_common_fx table ...</div><div class='long'><p>gets currency codes form sol_common_fx table</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-convertAmount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-convertAmount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-convertAmount' class='name expandable'>convertAmount</a>( <span class='pre'>amount, from, to</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Converts an amount from one currency to another. ...</div><div class='long'><p>Converts an amount from one currency to another.</p>\n\n<p>Because all exchange rates refer to EUR the conversion has up to two steps: FROM_CURRENCY -> EUR ( -> TO_CURRENCY)</p>\n\n<p>Result object:</p>\n\n<pre><code>{\n  amount: \"47.11\",\n  from: \"USD\",\n  to: \"EUR\",\n  result: \"42.06\"\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>amount</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>from</span> : String<div class='sub-desc'><p>The currency of the amount</p>\n</div></li><li><span class='pre'>to</span> : String<div class='sub-desc'><p>The currency in which the amount should be converted. If undfined 'baseCurrency' will be used (see <a href=\"#!/api/sol.common_fx.ix.FxUtils-property-configuration\" rel=\"sol.common_fx.ix.FxUtils-property-configuration\" class=\"docClass\">baseCurrency</a>)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-convertLocalCurrency' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-convertLocalCurrency' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-convertLocalCurrency' class='name expandable'>convertLocalCurrency</a>( <span class='pre'>currencies</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Converts the currencies to another local currency ...</div><div class='long'><p>Converts the currencies to another local currency</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencies</span> : Object<div class='sub-desc'><p>Currencies</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Converted currencies</p>\n</div></li></ul></div></div></div><div id='method-fillHistoricData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-fillHistoricData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-fillHistoricData' class='name expandable'>fillHistoricData</a>( <span class='pre'>serviceUrl</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>requests and parses an xml file containing historical\nforeign exchange rates\nand writes these entries to the history ...</div><div class='long'><p>requests and parses an xml file containing historical\nforeign exchange rates\nand writes these entries to the history table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>serviceUrl</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getExchangeRateByCodeAndDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-getExchangeRateByCodeAndDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-getExchangeRateByCodeAndDate' class='name expandable'>getExchangeRateByCodeAndDate</a>( <span class='pre'>currencyCode, isoDate</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>gets exchange rate from history table if available\nOtherwise the current rate is returned ...</div><div class='long'><p>gets exchange rate from history table if available\nOtherwise the current rate is returned</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencyCode</span> : String<div class='sub-desc'><p>currency code</p>\n</div></li><li><span class='pre'>isoDate</span> : String<div class='sub-desc'><p>ELO iso date string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result object with or without exchange rate</p>\n</div></li></ul></div></div></div><div id='method-getExchangeRateForCurrency' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-getExchangeRateForCurrency' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-getExchangeRateForCurrency' class='name expandable'>getExchangeRateForCurrency</a>( <span class='pre'>currencyCode</span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrives the exchange rate for one currency from the database. ...</div><div class='long'><p>Retrives the exchange rate for one currency from the database.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencyCode</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The exchange rate</p>\n</div></li></ul></div></div></div><div id='method-getExchangeRates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-getExchangeRates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-getExchangeRates' class='name expandable'>getExchangeRates</a>( <span class='pre'>url</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the exchange rates from an external service. ...</div><div class='long'><p>Retrieves the exchange rates from an external service.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>The service URL</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The service response</p>\n</div></li></ul></div></div></div><div id='method-getHistoricalExchangeRate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-getHistoricalExchangeRate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-getHistoricalExchangeRate' class='name expandable'>getHistoricalExchangeRate</a>( <span class='pre'>currencyCode, isoDate</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Reads exchange rate by date and code from history table ...</div><div class='long'><p>Reads exchange rate by date and code from history table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencyCode</span> : String<div class='sub-desc'><p>currencyCode</p>\n</div></li><li><span class='pre'>isoDate</span> : String<div class='sub-desc'><p>isoDate, ELO iso date string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>object with or without exchange rate</p>\n</div></li></ul></div></div></div><div id='method-getOldestEntryForCurrency' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-getOldestEntryForCurrency' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-getOldestEntryForCurrency' class='name expandable'>getOldestEntryForCurrency</a>( <span class='pre'>currencyCode</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>selects row in historical database by currency code\nand minimum isodate ...</div><div class='long'><p>selects row in historical database by currency code\nand minimum isodate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencyCode</span> : String<div class='sub-desc'><p>currencyCode</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-historicDataFilled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-historicDataFilled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-historicDataFilled' class='name expandable'>historicDataFilled</a>( <span class='pre'>isoDateStr</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>checks data count and latest entry in history table ...</div><div class='long'><p>checks data count and latest entry in history table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDateStr</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-historyTableHasEntries' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-historyTableHasEntries' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-historyTableHasEntries' class='name expandable'>historyTableHasEntries</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>checks if the history table has entries ...</div><div class='long'><p>checks if the history table has entries</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-latestHistoryDateIsCurrent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-latestHistoryDateIsCurrent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-latestHistoryDateIsCurrent' class='name expandable'>latestHistoryDateIsCurrent</a>( <span class='pre'>isoDateStr</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>checks if latest date for the base currency\nin the history table is older than the\ntwo days before the given isodate ...</div><div class='long'><p>checks if latest date for the base currency\nin the history table is older than the\ntwo days before the given isodate string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>isoDateStr</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadExchangeRates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-loadExchangeRates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-loadExchangeRates' class='name expandable'>loadExchangeRates</a>( <span class='pre'>[persist]</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads the exchange rates from an external service. ...</div><div class='long'><p>Loads the exchange rates from an external service.</p>\n\n<p>Result object:</p>\n\n<pre><code>{\n  \"USD\": \"1.1389\",\n  \"JPY\": \"136.33\",\n  \"BGN\": \"1.9558\",\n  ...\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>persist</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, the database will be updated</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The exchange rates</p>\n</div></li></ul></div></div></div><div id='method-parseDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-parseDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-parseDate' class='name expandable'>parseDate</a>( <span class='pre'>text</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Parses the request date from a text using a regular expression (see timeRegex). ...</div><div class='long'><p>Parses the request date from a text using a regular expression (see <a href=\"#!/api/sol.common_fx.ix.FxUtils-property-configuration\" rel=\"sol.common_fx.ix.FxUtils-property-configuration\" class=\"docClass\">timeRegex</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ISO date</p>\n</div></li></ul></div></div></div><div id='method-queryHistoricalExchangeRateByPeriod' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-queryHistoricalExchangeRateByPeriod' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-queryHistoricalExchangeRateByPeriod' class='name expandable'>queryHistoricalExchangeRateByPeriod</a>( <span class='pre'>currencyCode, dates</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks history table for currency by code and date\nwithin a configurable time frame ...</div><div class='long'><p>Checks history table for currency by code and date\nwithin a configurable time frame</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencyCode</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>dates</span> : Object<div class='sub-desc'><p>@params {String} dates.isoDate, ELO iso date string\n@params {String} dates.isoLowerTimeLimit, ELO iso date string\n@params {String} dates.isoUpperTimeLimit, ELO iso date string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-recordExchangeRateHistory' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-recordExchangeRateHistory' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-recordExchangeRateHistory' class='name expandable'>recordExchangeRateHistory</a>( <span class='pre'>currencies, time, checkExisting</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Records exchange rates to the history table in the database. ...</div><div class='long'><p>Records exchange rates to the history table in the database.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencies</span> : Object<div class='sub-desc'><p>Currencies</p>\n</div></li><li><span class='pre'>time</span> : String<div class='sub-desc'><p>Time</p>\n</div></li><li><span class='pre'>checkExisting</span> : Boolean<div class='sub-desc'><p>checkExisting</p>\n</div></li></ul></div></div></div><div id='method-sortExchangeRateEntries' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-sortExchangeRateEntries' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-sortExchangeRateEntries' class='name expandable'>sortExchangeRateEntries</a>( <span class='pre'>currencies, time, checkExisting</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Sorts exchange rates into new entries and\nexisting entries with rates that need updating. ...</div><div class='long'><p>Sorts exchange rates into new entries and\nexisting entries with rates that need updating.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencies</span> : Object<div class='sub-desc'><p>Currencies</p>\n</div></li><li><span class='pre'>time</span> : String<div class='sub-desc'><p>Time</p>\n</div></li><li><span class='pre'>checkExisting</span> : Boolean<div class='sub-desc'><p>checkExisting</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-updateExchangeRateHistory' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-updateExchangeRateHistory' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-updateExchangeRateHistory' class='name expandable'>updateExchangeRateHistory</a>( <span class='pre'>results</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Updates existing entries into the history table ...</div><div class='long'><p>Updates existing entries into the history table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>results</span> : Array<div class='sub-desc'><p>results</p>\n</div></li></ul></div></div></div><div id='method-updateExchangeRates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common_fx.ix.FxUtils'>sol.common_fx.ix.FxUtils</span><br/><a href='source/lib_sol.common_fx.ix.FxUtils.html#sol-common_fx-ix-FxUtils-method-updateExchangeRates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common_fx.ix.FxUtils-method-updateExchangeRates' class='name expandable'>updateExchangeRates</a>( <span class='pre'>currencies, time</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Writes updated exchange rates to the database. ...</div><div class='long'><p>Writes updated exchange rates to the database.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currencies</span> : Object<div class='sub-desc'><p>Currencies</p>\n</div></li><li><span class='pre'>time</span> : String<div class='sub-desc'><p>Time</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"singleton":true}});